// F-Curve Utility.js
//
// Tool script for installation ~/Library/Application Support/Cheetah3D/scripts/Tool folder
//
//

var Vec3D_toString = function( vec ) {
	return '(' + vec.x.toFixed(4) + ', ' + vec.y.toFixed(4) + ', ' + vec.z.toFixed(4) + ')';
}

//

function buildUI( tool ) {
	
  // 6.0+ version check
  if (! tool.parameterWithName) {
    OS.messageBox( "Cheetah3D version error!", "Sorry. this tool is available for Cheetah3D 6.0 above.");
    OS.beep();
    return;
  }
  tool.addParameterSeparator("Target");
  
  tool.addParameterInt("target tag index", -1, -1, 1000, false, false);
  tool.addParameterBool("hierarchy aware", 0, 0, 1, false, false);
    
  tool.addParameterSeparator("Remove All KeyFrames");

  tool.addParameterSelector("remove range", ["selection", "all"], false, false );

  tool.addParameterButton("remove all", "remove", "removeAllKeyframes");

  tool.addParameterSeparator("Move F-Curve");
  
  tool.addParameterSelector("move range", ["selection", "all"], false, false );
  tool.addParameterFloat("time factor", 0, -10000, 10000, false, false);
  tool.addParameterFloat("value factor", 0, -10000, 10000, false, false);
  tool.addParameterButton("move", "apply", "moveFCurve");
  tool.addParameterButton("randomize", "apply", "randomizeFCurve");
  
  tool.addParameterSeparator("Time Reverse");
  
  tool.addParameterSelector("reverse range", ["selection", "all"], false, false );
  tool.addParameterButton("time reverse", "apply", "timeReverse");
  
  tool.addParameterSeparator("Time Remapper");
  
  tool.addParameterSelector("remap range", ["selection", "all"], false, false );
  tool.addParameterSelector("remap mode", ["use time length", "use time scale"], false, false );
  tool.addParameterSelector("remap repeat", ["constant", "linear inc", "lienar dec"], false, false );
  tool.addParameterFloat("time length", 1, 0, 100000, false, false);
  tool.addParameterFloat("time scale", 1, -10000, 10000, false, false);
  tool.addParameterButton("time remap", "apply", "timeRemap");
  
  tool.addParameterSeparator("Oscillator");
  
  tool.addParameterInt("oscillate count", 5, 2, 10000, false, false);
  tool.addParameterSelector("oscillate base", ["middle", "first", "second"], false, false);
  tool.addParameterSelector("oscillate repeat", ["constant", "linear inc", "lienar dec", "curve inc", "curve dec"], false, false );
  tool.addParameterButton("oscillate f-curve", "apply", "oscillateFCurve", false, false );
}

function removeAllKeyframes( tool ) {
  var obj = tool.document().selectedObject();
  var recursive = tool.getParameter("hierarchy aware");
  
  if (!obj) return;
  
  var tagIndex = tool.getParameter("target tag index");
  if (tagIndex > -1 && tagIndex < obj.tagCount()) {
    obj = obj.tagAtIndex( tagIndex );
  }
  
  removeAllKeyFrameRecursive( tool, obj, ( recursive && tagIndex == -1 )? true : false );
}

function removeAllKeyFrameRecursive( tool, obj, recursive ) {

  if (recursive) {
    var childCount = obj.childCount();
    for (var i = 0;i < childCount;i++) {
      var child = obj.childAtIndex( i );
      
      removeAllKeyFrameRecursive( tool, child, recursive );
    }
  }

  var currentTake = tool.document().currentTake();
  var tSel = tool.getParameter("remove range");

  obj.recordParametersForUndo();

  var pCount = obj.parameterCount();
  for (var i = 0;i < pCount;i++) {
    var p = obj.parameterAtIndex( i );
    
    var takeNode = p.takeNodeWithName( currentTake.name );
    if (takeNode) {
      var fCount = takeNode.fCurveCount();
      for (var j = 0;j < fCount;j++) {
        var curve = takeNode.fCurveAtIndex( j );
        var keyCount = curve.keyCount();
        if (keyCount > 0) {
          if (tSel == 0) {
            var sele = [];
            for (var k = 0;k < keyCount;k++) {
              var key = curve.keyAtIndex(k);
              if (!key.selected) {
                sele.push( key );
              }
            }
            curve.removeAllKeys();

            // 
            var len = sele.length;
            for (var k = 0;k < len;k++) {
              var key = sele[k];
              curve.insertKeyAtIndex( key, curve.keyCount() );
            }

          } else {
            curve.removeAllKeys();
          }
        }
        
        curve.update();
      }
    }
  }
}

function moveFCurve( tool ) {
  var obj = tool.document().selectedObject();
  var recursive = tool.getParameter("hierarchy aware");
  
  if (!obj) return;
  
  var tagIndex = tool.getParameter("target tag index");
  if (tagIndex > -1 && tagIndex < obj.tagCount()) {
    obj = obj.tagAtIndex( tagIndex );
  }
  
  moveFCurveRecursive( tool, obj, false, ( recursive && tagIndex == -1 )? true : false );
}

function randomizeFCurve( tool ) {
  var obj = tool.document().selectedObject();
  var recursive = tool.getParameter("hierarchy aware");
  
  if (!obj) return;
  
  var tagIndex = tool.getParameter("target tag index");
  if (tagIndex > -1 && tagIndex < obj.tagCount()) {
    obj = obj.tagAtIndex( tagIndex );
  }
  
  moveFCurveRecursive( tool, obj, true, ( recursive && tagIndex == -1 )? true : false );
}

function moveFCurveRecursive( tool, obj, randomize, recursive ) {

  if (recursive) {
    var childCount = obj.childCount();
    for (var i = 0;i < childCount;i++) {
      var child = obj.childAtIndex( i );
      
      moveFCurveRecursive( tool, child, randomize, recursive );
    }
  }
  
  var currentTake = tool.document().currentTake();
  
  var tSel = tool.getParameter("move range");
  var timeFactor = tool.getParameter("time factor");
  var valueFactor = tool.getParameter("value factor");
  
  obj.recordParametersForUndo();
  
  var pCount = obj.parameterCount();
  for (var i = 0;i < pCount;i++) {
    var p = obj.parameterAtIndex( i );
    
    var takeNode = p.takeNodeWithName( currentTake.name );
    if (takeNode) {
      var fCount = takeNode.fCurveCount();
      for (var j = 0;j < fCount;j++) {
        var sele = [];
        var timeMin;
        var timeMax;
        var curve = takeNode.fCurveAtIndex( j );
        var keyCount = curve.keyCount();
        for (var k = 0;k < keyCount;k++) {
          var key = curve.keyAtIndex( k );
          if (tSel == 1 || key.selected) {
            sele.push( [ k, key ] );
          }
        }
        // current time length
        var len = sele.length;
        for (var k = 0;k < len;k++) {
          var key = sele[k][1];
          if ( randomize ) {
            key.value += (Math.random() - 0.5) * valueFactor; //(valueFactor/2) + (Math.random() * valueFactor);
            key.time += (Math.random() - 0.5) * timeFactor; //(timeFactor/2) + (Math.random() * timeFactor);
          } else {
            key.value += valueFactor;
            key.time += timeFactor;
          }
          if (key.time < 0) key.time = 0; // 0 check
          curve.setKeyAtIndex( key, sele[k][0] );
        }
        
        curve.update();
      }
    }
  }
}

function timeReverse( tool ) {
  var obj = tool.document().selectedObject();
  var recursive = tool.getParameter("hierarchy aware");
  
  if (!obj) return;
  
  var tagIndex = tool.getParameter("target tag index");
  
  if (tagIndex > -1 && tagIndex < obj.tagCount() ) {
    obj = obj.tagAtIndex( tagIndex );
  }
  
  timeReverseRecursive( tool, obj, ( recursive && tagIndex == -1)? true : false );
}

function timeReverseRecursive( tool, obj, recursive ) {
  
  if (recursive) {
    var childCount = obj.childCount();
    for (var i = 0;i < childCount;i++) {
      var child = obj.childAtIndex( i );
      
      timeReverseRecursive( tool, child, recursive );
    }
  }
  
  var currentTake = tool.document().currentTake();
  
  var tSel = tool.getParameter("reverse range");
  
  obj.recordParametersForUndo();
  
  var pCount = obj.parameterCount();
  for (var i = 0;i < pCount;i++) {
    var p = obj.parameterAtIndex( i );
    
    var takeNode = p.takeNodeWithName( currentTake.name );
    if (takeNode) {
      var fCount = takeNode.fCurveCount();
      for (var j = 0;j < fCount;j++) {
        var sele = [];
        var timeMin;
        var timeMax;
        var curve = takeNode.fCurveAtIndex( j );
        var keyCount = curve.keyCount();
        for (var k = 0;k < keyCount;k++) {
          var key = curve.keyAtIndex( k );
          if (tSel == 1 || key.selected) {
            if (sele.length == 0) {
              timeMin = key.time;
              timeMax = key.time;
            } else {
              timeMin = (key.time < timeMin)? key.time : timeMin;
              timeMax = (key.time > timeMax)? key.time : timeMax;
            }
            sele.push( [ k, key ] );
          }
        }
        
        if (sele.length < 2) {
          continue;
        }
        //
        var timeLength = timeMax - timeMin;
        //
        var len = sele.length;
        for (var k = 0;k < len;k++) {
          var key = sele[k][1];
          //
          var right_value = key.right_value;
          var right_time = key.right_time;
          var left_value = key.left_value;
          var left_time = key.left_time;
          
          key.right_value = left_value;
          key.right_time = left_time * -1;
          key.left_value = right_value;
          key.left_time = right_time * -1;
          key.time = timeMin + ( timeMax + (key.time * -1) );
          
          curve.setKeyAtIndex( key, sele[k][0] );
        }

        curve.update();
      }
    }
  }
  
}

function timeRemap( tool ) {
  var obj = tool.document().selectedObject();
  var recursive = tool.getParameter("hierarchy aware");
  
  if (!obj) return;
  
  var tagIndex = tool.getParameter("target tag index");
  
  if (tagIndex > -1 && tagIndex < obj.tagCount()) {
    obj = obj.tagAtIndex( tagIndex );
  }
  
  timeRemapRecursive( tool, obj, ( recursive && tagIndex == -1 )? true : false );
}

function timeRemapRecursive( tool, obj, recursive ) {
  
  if (recursive) {
    var childCount = obj.childCount();
    for (var i = 0;i < childCount;i++) {
      var child = obj.childAtIndex( i );
      
      timeRemapRecursive( tool, child, recursive );
    }
  }
  
  var currentTake = tool.document().currentTake();

  var tSel = tool.getParameter("remap range");
  var tMode = tool.getParameter("remap mode");
  var tType = tool.getParameter("remap repeat");
  var tLength = tool.getParameter("time length");
  var tScale = tool.getParameter("time scale");
  
  obj.recordParametersForUndo();
  
  var pCount = obj.parameterCount();
  for (var i = 0;i < pCount;i++) {
    var p = obj.parameterAtIndex( i );
    
    var takeNode = p.takeNodeWithName( currentTake.name );
    if (takeNode) {
      var fCount = takeNode.fCurveCount();
      for (var j = 0;j < fCount;j++) {
        var sele = [];
        var timeMin;
        var timeMax;
        var curve = takeNode.fCurveAtIndex( j );
        var keyCount = curve.keyCount();
        for (var k = 0;k < keyCount;k++) {
          var key = curve.keyAtIndex( k );
          if (tSel == 1 || key.selected) {
            if (sele.length == 0) {
              timeMin = key.time;
              timeMax = key.time;
            } else {
              timeMin = (key.time < timeMin)? key.time : timeMin;
              timeMax = (key.time > timeMax)? key.time : timeMax;
            }
            sele.push( [ k, key ] );
          }
        }
        if (sele.length < 2) {
          continue;
        }
        // current time length
        var currentTimeLength = timeMax - timeMin;
        var scale = (tMode == 1)? tScale : tLength / currentTimeLength;
        //print( tLength + '/' + currentTimeLength + ':' + scale );
        var len = sele.length;        
        for (var k = 0;k < len;k++) {
          var key = sele[k][1];
          switch (tType) {
            case 0: // constant
              if (k > 0) key.left_time *= scale;
              if (k < len - 1) key.right_time *= scale;
              if (k > 0) key.time = ((key.time - timeMin) * scale) + timeMin;
              break;
            case 1: // linear inc
              var tt = (key.time - timeMin) / currentTimeLength;
              if (k > 0) key.left_time *= scale * tt;
              if (k < len - 1) key.right_time *= scale * tt;
              if (k > 0) key.time = timeMin + ((key.time - timeMin) * scale * tt);
              break;
            case 2: // linear dec
              var tt = (currentTimeLength + timeMax - key.time) / currentTimeLength;
              if (k > 0) key.left_time *= scale * tt;
              if (k < len - 1) key.right_time *= scale * tt;
              if (k > 0) key.time = timeMin + ((key.time - timeMin) * scale * tt);
              break;
          }
          //print( k + ':' + key.time );
          curve.setKeyAtIndex( key, sele[k][0] );
        }
        
        curve.update();
      }
    }
  }
}

function oscillateFCurve( tool ) {
  var obj = tool.document().selectedObject();
  var recursive = tool.getParameter("hierarchy aware");
  
  if (!obj) return;
  
  var tagIndex = tool.getParameter("target tag index");
  
  if (tagIndex > -1 && tagIndex < obj.tagCount()) {
    obj = obj.tagAtIndex( tagIndex );
  }
  
  oscillateFCurveRecursive( tool, obj, ( recursive && tagIndex == -1 )? true : false );
}

function oscillateFCurveRecursive( tool, obj, recursive ) {
  
  if (recursive) {
    var childCount = obj.childCount();
    for (var i = 0;i < childCount;i++) {
      var child = obj.childAtIndex( i );
      
      oscillateFCurveRecursive( tool, child, recursive );
    }
  }
  
  var currentTake = tool.document().currentTake();
  
  var oType = tool.getParameter("oscillate repeat");
  var oBase = tool.getParameter("oscillate base");
  var oCount = tool.getParameter("oscillate count");
  
  obj.recordParametersForUndo();
  
  var pCount = obj.parameterCount();
  for (var i = 0;i < pCount;i++) {
    var p = obj.parameterAtIndex( i );
    
    var takeNode = p.takeNodeWithName( currentTake.name );
    if (takeNode) {
      var fCount = takeNode.fCurveCount();
      for (var j = 0;j < fCount;j++) {
        var sele = [];
        var curve = takeNode.fCurveAtIndex( j );
        var keyCount = curve.keyCount();
        for (var k = 0;k < keyCount;k++) {
          var key = curve.keyAtIndex( k );
          //print( i + ':' + j + ':' + k + '- ' + key.value );
          if (key.selected) {
            sele.push( [k, key] );
          }
        }
        // make oscilation
        if (sele.length < 2) {
          continue;
        }
        if (sele.length > 2) {
          OS.messageBox("Too Many Selection!", "Please select just 2 points for start and end for "+p.name()+".");
          continue;
        }
        var val1 = sele[0][1];
        var val2 = sele[1][1];
        
        curve.removeKeyAtIndex(sele[1][0]);
        curve.removeKeyAtIndex(sele[0][0]);
        
        var timeStart = val1.time;
        var timeSpan = Math.abs( val2.time - val1.time );
        var timeD = timeSpan / (oCount);
        
        switch( oBase ) {
          case 0:
            var valSpan1 = (val2.value - val1.value) / 2;
            var valSpan2 = (val1.value - val2.value ) / 2;
            var valMiddle = (val1.value + val2.value) / 2;
            break;
          case 1: // first
            var valSpan1 = 0;
            var valSpan2 = (val2.value - val1.value );
            var valMiddle = (val1.value + val2.value) / 2;
            break;
          case 2: // second
            var valSpan1 = (val1.value - val2.value);
            var valSpan2 = 0;
            var valMiddle = (val1.value + val2.value) / 2;
            break;
        }
        
        for (var oi = 0;oi < oCount + 1;oi++) {
          var copyVal, valSpan, addVal;
          
          if (oi % 2) {
            copyVal = val2;
            valSpan = valSpan1;
          } else {
            copyVal = val1;
            valSpan = valSpan2;
          }
          
          switch( oType ) {
            case 0: // constant
              addVal = (valSpan);
              break;
            case 1: // linear inc
              addVal = (valSpan) / oCount * oi;
              break;
            case 2: // linear dec
              addVal = (valSpan) / oCount * (oCount - oi);
              break;
            case 3: // curve - inc
              addVal = (valSpan) * ((1/oCount) * oi) * ((1/oCount) * oi);
              break;
            case 4: // curve - dec
              addVal = (valSpan) * ((1/oCount) * (oCount - oi)) * ((1/oCount) *  (oCount - oi));
              break;
            case 5:
              break;
          }
          
          var newKey = new FCurveKey();
          
          newKey.selected = true;
          newKey.left_type = copyVal.left_type;
          newKey.left_time = copyVal.left_time;
          newKey.right_type = copyVal.right_type;
          newKey.right_time = copyVal.right_time;
          
          newKey.time = timeStart + (timeD * oi);
          
          newKey.left_value = val1.left_value;
          newKey.right_value = val1.right_value;
          newKey.value = valMiddle + addVal;
          //print( oi + ':' + valMiddle + '+' + addVal );
          
          curve.addKey( newKey );
        }
        
        curve.update();
      }
    }
  }
}

